<?php
	/*
	* GMapFP Component Google Map for Joomla! 4.0.x
	* Version J4_0_8
	* Creation date: Septembre 2023
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

defined('JPATH_BASE') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Component\Gmapfp\Site\Helper\RouteHelper as GmapfpRoute;

$app 	= Factory::getApplication();
$params = $displayData['params'];
$item	= $displayData['item'];
$images = json_decode($item->img);
// die(print_r($displayData));
$view = $app->input->get('view','');
$height = '';

//force la taille de l'image (pour le module)
if ($params->get('gmapfp_height_picture', 0))
	$height = 'style="height:'.$params->get('gmapfp_height_picture', 0).'px !important;"';
?>
<?php if (!empty($images->image)) : ?>
	<figure class="item-image">
		<?php if ($view=='item' or $params->get('main_image_target', 0) == 0) : ?>
		<a data-fancybox="gmapfp_image" href="<?php echo $images->image; ?>">
		<?php endif; ?>
		<?php if ($view!='item' and $params->get('main_image_target', 0) == 1) : ?>
		<a class="gmapfp_link_image" href="<?php echo Route::_('index.php?option=com_gmapfp&view=item&id='.$item->slug); ?>" itemprop="url">
		<?php endif; ?>
			<img loading="lazy" <?php echo $height; ?> src="<?php echo htmlspecialchars($images->image, ENT_COMPAT, 'UTF-8'); ?>"
				 alt="<?php echo htmlspecialchars($images->image_alt, ENT_COMPAT, 'UTF-8'); ?>"
				 itemprop="image" class="gmapfp-thumbnail img-thumbnail"/>
		<?php if ($params->get('main_image_target', 0) == 0 or $params->get('main_image_target', 0) == 1) : ?>
		</a>
		<?php endif; ?>
		<?php if (isset($images->image_caption) && $images->image_caption !== '') : ?>
			<figcaption class="caption"><?php echo htmlspecialchars($images->image_caption, ENT_COMPAT, 'UTF-8'); ?></figcaption>
		<?php endif; ?>
	</figure>
<?php endif; ?>
