<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.0
	* Creation date: Août 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

class ContactMapViewmarqueurs extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	public function display($tpl = null)
	{
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));

			return false;
		}

		ContactMapHelper::addSubmenu('marqueurs');

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	protected function addToolbar()
	{
		require_once JPATH_COMPONENT . '/helpers/contactmap.php';

		$canDo = JHelperContent::getActions('com_contactmap');

		JToolbarHelper::title(JText::_('COM_CONTACTMAP_MANAGER_MARQUEURS'), 'marqueurs.png');

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::addNew('marqueur.add');
		}

		if ($canDo->get('core.edit'))
		{
			JToolbarHelper::editList('marqueur.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::publish('marqueurs.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('marqueurs.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			JToolbarHelper::archiveList('marqueurs.archive');
		}

		if ($this->state->get('filter.state') == -2 && $canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('', 'marqueurs.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::trash('marqueurs.trash');
		}

		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_contactmap');
		}
	}

	protected function getSortFields()
	{
		return array(
			'a.published' => JText::_('JSTATUS'),
			'a.nom' => JText::_('COM_CONTACTMAP_HEADING_MARQUEUR'),
			'a.id' => JText::_('JGRID_HEADING_ID')
		);
	}
}
