<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.0
	* Creation date: Août 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

class ContactMapModelMarqueur extends JModelAdmin
{
	public $typeAlias = 'com_contactmap.marqueur';

	protected function canDelete($record)
	{
		if (!empty($record->id))
		{
			if ($record->state != -2)
			{
				return;
			}

			$user = JFactory::getUser();

			if (!empty($record->catid))
			{
				return $user->authorise('core.delete', 'com_contactmap.category.' . (int) $record->catid);
			}
			else
			{
				return $user->authorise('core.delete', 'com_contactmap');
			}
		}
	}

	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		if (!empty($record->catid))
		{
			return $user->authorise('core.edit.state', 'com_contactmap.category.' . (int) $record->catid);
		}
		else
		{
			return $user->authorise('core.edit.state', 'com_contactmap');
		}
	}

	public function getTable($type = 'Marqueur', $prefix = 'ContactMapTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_contactmap.marqueur', 'marqueur', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_contactmap.edit.marqueur.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		$this->preprocessData('com_contactmap.marqueur', $data);

		return $data;
	}

	protected function prepareTable($table)
	{
		$table->name = htmlspecialchars_decode($table->name, ENT_QUOTES);
	}
}
