<?php
	/*
	* GMapFP Component Google Map for Joomla! 4.0.x
	* Version J4_0_9P
	* Creation date: Octobre 2023
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Gmapfp\Administrator\Extension\GmapfpComponent;
use Joomla\Component\Gmapfp\Site\Helper\RouteHelper as GmapfpRoute;

// Create shortcuts to some parameters.
$params  = $this->item->params;
$images  = json_decode($this->item->img);
$canEdit = $params->get('access-edit');
$user    = Factory::getUser();
$info    = $params->get('info_block_position', 0);
$user_template = $params->get('item_layout', '');

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));
?>
<?php if (!$user_template) : ?>
	<div class="row com-gmapfp-item__intro">
		<div class="col-md-4">
			<?php if ($params->get('show_image', 1)) : ?>
				<?php echo LayoutHelper::render('image', array('item' => $this->item, 'params' => $params)); ?>
			<?php endif; ?>
		</div>
		<div class="col-md-4">
			<?php echo LayoutHelper::render('adresse', array('item' => $this->item, 'params' => $params)); ?>
			<?php if ($params->get('item_navigation', 0)) : ?>
				<?php echo LayoutHelper::render('yaller', array('item' => $this->item, 'params' => $params)); ?>
			<?php endif; ?>
		</div>
		<div class="col-md-4">
			<?php echo LayoutHelper::render('phone', array('item' => $this->item, 'params' => $params)); ?>
			<?php echo LayoutHelper::render('email', array('item' => $this->item, 'params' => $params)); ?>
			<?php echo LayoutHelper::render('web', array('item' => $this->item, 'params' => $params)); ?>
		</div>
	</div>
	<?php
	if (!empty($this->item->pagination) && $this->item->pagination && !$this->item->paginationposition && !$this->item->paginationrelative) :
		echo $this->item->pagination;
	endif;
	?>
	<div itemprop="articleBody" class="com-gmapfp-item__body">
		<?php echo $this->item->text; ?>
	</div>

	<?php if ($info == 1 || $info == 2) : ?>
		<?php if ($useDefList) : ?>
			<?php echo LayoutHelper::render('info_block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
		<?php endif; ?>
		<?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
			<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
			<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
		<?php endif; ?>
	<?php endif; ?>

	<?php if ($params->get('show_readmore',1) && isset($this->item->readmore) && $this->item->readmore) :
		if ($params->get('access-view')) :
			$link = Route::_(GmapfpRoute::getItemRoute($this->item->slug, $this->item->catid, $this->item->language));
		else :
			$menu = Factory::getApplication()->getMenu();
			$active = $menu->getActive();
			$itemId = $active->id;
			$link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
			$link->setVar('return', base64_encode(GmapfpRoute::getItemRoute($this->item->slug, $this->item->catid, $this->item->language)));
		endif; ?>
		<?php echo LayoutHelper::render('readmore', array('item' => $this->item, 'params' => $params, 'link' => $link)); ?>
	<?php endif; ?>
<?php else : ?>	
	<?php echo LayoutHelper::render('templates/'.$user_template, array('item' => $this->item, 'params' => $params, 'width' => $params->get('gmapfp_largeur_img_art', 5))); ?>
<?php endif; ?>
