<?php
	/*
	* GMapFP Plugin list for Page Builder CK
	* Version J3_4
	* Creation date: Janvier 2018
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

$input = JFactory::getApplication()->input;
$id = $input->get('ckid', '', 'string');

$com_gmapfp_exist = file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php');
if ($com_gmapfp_exist) {

	// build list of categories
	$categories = JHtml::_('category.options', 'com_gmapfp');
	array_unshift($categories, JHTML::_('select.option', '', '-- '.'toutes les catégories'.' --' ));
	$lists['catid_filtre'] = JHTML::_('select.genericlist', $categories, 'filtre_gmapfpcatid', 'onchange="change_gmapfpcatid();" class="input" ', 'value', 'text');
}
?>
<div id="elementscontainer">
	<div class="menulink" tab="tab_list"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_EDITION'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_list">
		<div class="layoutinfos">
			<div class="layoutinfostitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_INFOS'); ?></div>
			<div class="layoutinfosdesc"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_INFOS_DESC'); ?></div>
		</div>
		
		<div class="clr"></div>
				
		<div class="menustylesblocktitle"><?php echo JText::_('JGLOBAL_USE_GLOBAL') ?></div>
		<div class="menustylesblockaccordion">
			<div style="text-align:left;">
				<div class="menupanetitle"><?php echo JText::_('JCATEGORIES'); ?></div>
				<select id="gmapfpcatid" name="gmapfpcatid[]" onchange="update_places()" class="input-xxlarge inputbox" style="width:280px; height:80px;" multiple="">
				</select>
				<div id="sablier" style="float:right;">
					<img style="height:72px;" src="<?php echo JUri::root(true); ?>/plugins/pagebuilderck/gmapfp_liste/assets/images/gif-load.gif" />
				</div>
				<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_LIEUX'); ?></div>
				<?php echo $lists['catid_filtre']; ?>
				<div class="clr"></div>
				<select id="gmapfpplaceid" name="gmapfpplaceid[]" onchange="update_places()" class="input-xxlarge inputbox" style="width:280px; height:80px;" multiple="">
				</select>
			</div>
			<div class="clr"></div>
		</div>
		<div class="menustylesblocktitle"><?php echo JText::_('JGLOBAL_FIELDSET_ADVANCED') ?></div>
		<div class="menustylesblockaccordion">
			<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_LINK'); ?></div>
			<div style="text-align:left;">
				<select class="input-large inputbox" style="width:210px;" name="gmapfplink" id="gmapfplink">
					<option value="3"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_IMG') ?></option>
					<option value="2"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_TITLE') ?></option>
					<option value="1"  selected><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_ALL') ?></option>
					<option value="0"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_NO_LINK') ?></option>
				</select>
			</div>
			<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_TITLE_VIEW'); ?></div>
			<div style="text-align:left;">
				<select class="input-large inputbox" onchange="update_gmapfp_params();" style="width:210px;" name="gmapfph" id="gmapfph">
					<option value="1"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_BALISE_H1') ?></option>
					<option value="2"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_BALISE_H2') ?></option>
					<option value="3"  selected><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_BALISE_H3') ?></option>
					<option value="4"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_BALISE_H4') ?></option>
					<option value="0"><?php echo JText::_('JHIDE') ?></option>
				</select>
			</div>
			<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_IMAGE'); ?></div>
			<div style="text-align:left;">
				<select class="input-large inputbox" style="width:210px;" name="gmapfpimg" id="gmapfpimg">
					<option value="0"><?php echo JText::_('JHIDE') ?></option>
					<option value="1"  selected><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_IMAGE_GEN') ?></option>
					<option value="2"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_IMAGE_ART') ?></option>
					<option value="3"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_LISTE_IMAGE_MAIN') ?></option>
				</select>
			</div>
			<div style="text-align:left;">
				<div style="float:left;text-align:right;margin:5px 5px 0 10px;line-height: 15px;;"><?php echo JText::_('CK_HEIGHT'); ?></div>
				<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>height.png" width="15" height="15" align="top" /></div>
				<div style="float:left;"><input class="inputbox" onchange="update_gmapfp_params();" type="text" name="gmapfpheight" id="gmapfpheight" size="2" value="60px" style="" /></div>
				<div style="float:left;text-align:left;margin-left:3px;"></div>
			</div>
			<div class="clr"></div>
			<div style="text-align:left;">
				<div style="float:left;text-align:right;margin:5px 5px 0 10px;line-height: 15px;;"><?php echo JText::_('CK_ROUNDED_CORNERS'); ?></div>
				<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>all_corners.png" width="15" height="15" align="top" /></div>
				<div style="float:left;"><input class="inputbox" onchange="update_gmapfp_params();" type="text" name="gmapfpradius" id="gmapfpradius" size="2" value="30px" style="" /></div>
				<div style="float:left;text-align:left;margin-left:3px;"></div>
			</div>
			<div class="clr"></div>
		</div>
	</div>
	<div class="menulink" tab="tab_blocstyles"><?php echo JText::_('CK_STYLES'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_blocstyles">
		<?php echo $this->menustyles->createBlocStyles('bloc', 'map', '') ?>
	</div>
</div>
<div id="previewarea" class="clearfix" style="display: none">
	<div class="previewareatitle"><?php echo JText::_('CK_PREVIEWAREA_TITLE'); ?></div>
	<div id="previewareabloc">
		<div class="ckstyle"></div>
		<div class="inner">
			<div id="<?php echo $id; ?>" class="gmapfpck cktype">
				<ul>
				</ul>
			</div>
		</div>
	</div>
</div>
<div class="clr"></div>
<?php 
	$gmapfp_pro =  file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/champs.php');
	$URL = JURI::base(); 
	$URL = str_replace('/administrator', '', $URL);
	if ($gmapfp_pro)
		$URL .= 'images/gmapfp/thumbsGMap/';
	else
		$URL .= 'images/gmapfp/';
?>
<script language="javascript" type="text/javascript">
var image_path = '<?php echo $URL; ?>';
var places_and_cat_place = false;

function ckLoadEditionPopup() {
	var focus = $ck('.editfocus');
	$ck('#previewareabloc .ckstyle').html(focus.find('.ckstyle').html());
	$ck('#previewarea .gmapfpck').html(focus.find('.gmapfpck').html());
	upload_gmapfpcatid()
	ckFillEditionPopup(focus.attr('id'));
}

function update_gmapfp_params() {
	var focus = $ck('.editfocus');
	var tag = "";
	//test si h1, h2, h3 ou h4
	if($ck('#' + focus.attr('id') + ' h1').length) tag = "h1";
	if($ck('#' + focus.attr('id') + ' h2').length) tag = "h2";
	if($ck('#' + focus.attr('id') + ' h3').length) tag = "h3";
	if($ck('#' + focus.attr('id') + ' h4').length) tag = "h4";
	
	new_tag = $ck("#gmapfph").val();
	new_height = $ck("#gmapfpheight").val();
	new_radius = $ck("#gmapfpradius").val();
	
	if (new_tag == 0) {
		$ck('#' + focus.attr('id') + ' ' + tag).fadeOut();
	} else {
		if (tag) {
			$ck('#' + focus.attr('id') + ' ' + tag).each(function(){
				var elemH2 = $ck(this);
				if (elemH2.text() != "") elemH2.replaceWith('<h' + new_tag + '>' + elemH2.text() + '</h' + new_tag + '>');
			});
			$ck('#' + focus.attr('id') + ' ' + tag).fadeIn();
		}
	}
	
	$ck('#' + focus.attr('id') + ' img').css('height', new_height);
	$ck('#' + focus.attr('id') + ' img').css('border-radius', new_radius);

}

function ckBeforeSaveEditionPopup() {
	var focus = $ck('.editfocus');
	focus.find('.ckstyle').html($ck('#previewareabloc .ckstyle').html());
	ckSaveEditionPopup(focus.attr('id'));
	ckCloseEditionPopup();
}

function update_places() {
	var cat_select = $ck("#gmapfpcatid option:selected");
	var places_select = $ck("#gmapfpplaceid option:selected");
	places_and_cat_place = false;
	$ck("#<?php echo $id; ?> .gmapfpck ul").remove();
	$ck("#previewarea .gmapfpck ul").remove();
	if (cat_select.length > 0) {
		var cat_ids = [];
		$ck.each(cat_select.valueOf(), function (index, cat_lieu_id) {
			cat_ids[index] = cat_lieu_id.value;
		});
		get_place_cat_info(cat_ids);
		places_and_cat_place = true;
	}
	if (places_select.length > 0) {
		var place_ids = [];
		$ck.each(places_select.valueOf(), function (index, cat_lieu_id) {
			place_ids[index] = cat_lieu_id.value;
		});
		get_place_info(place_ids);
	} else {
		//efface tout
		$ck(".gmapfpck ul li").remove("li");
	}
}

function get_place_info(value) {
	$ck('#sablier').fadeIn("fast");
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'get_place_info',
					'data'   : value,
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				var html;
				if(response.data){
					if (places_and_cat_place===false) {
						$ck("#<?php echo $id; ?> .gmapfpck ul").remove();
						$ck("#previewarea .gmapfpck ul").remove();
					}
					html = '<ul place_cat="">';
					$ck.each(response.data[0], function (index, lieu) {
						html = html + ' <li place_id="' + lieu.id + '"> <a href="#" class="gmapfp_list_item_link modal"> <div class="gmapfp_list_item_img"> <img src="' + image_path + lieu.img + '" style="height:60px;"> </div> <h3 class="gmapfp_list_item_title">' + lieu.nom + '</h3> </a> </li>';
					});
					html = html + '</ul>';
					$ck("#<?php echo $id; ?> .gmapfpck").append(html);
					$ck("#previewarea .gmapfpck").append(html);
					update_gmapfp_params();
				} else {
					$ck('.status').html(response);
				}
				$ck('#sablier').fadeOut("fast");
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
}
 
function get_place_cat_info(value) {
	$ck('#sablier').fadeIn("fast");
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'get_place_cat_info',
					'data'   : value,
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				var html;
				if(response.data){
					$ck("#previewarea .gmapfpck ul").remove();
					$ck("#<?php echo $id; ?> .gmapfpck ul").remove();
					html = '<ul place_cat="' + value + '">';
					$ck.each(response.data[0], function (index, lieu) {
						html = html + ' <li place_id="' + lieu.id + '"> <a href="#" class="gmapfp_list_item_link modal"> <div class="gmapfp_list_item_img"> <img src="' + image_path + lieu.img + '" style="height:60px;"> </div> <h3 class="gmapfp_list_item_title">' + lieu.nom + '</h3> </a> </li>';
					});
					html = html + '</ul>';
					$ck("#<?php echo $id; ?> .gmapfpck").append(html);
					$ck("#previewarea .gmapfpck").append(html);
					update_gmapfp_params();
				} else {
					$ck('.status').html(response);
				}
				$ck('#sablier').fadeOut("fast");
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
}
		var ids = new Array();

function FillGMapFPSelection(id) {
	var cat = $ck('#previewarea #' + id + ' ul');
	cat.each(function() {
		var the_cat = $ck(this).attr('place_cat');
		if (the_cat) {
			the_cat = the_cat.split(',');
			$ck('#gmapfpcatid').val(the_cat);
		} else {
			$ck(this).find('li').each(function(){
				ids.push($ck(this).attr('place_id'));
			})
			$ck('#gmapfpplaceid').val(ids);
		}
	});
	update_gmapfp_params();
	$ck('#sablier').fadeToggle("fast");
}

function change_gmapfpcatid() {    
	$ck('#sablier').fadeIn("fast");
	// var value = '{"catid": "' + $ck('#filtre_gmapfpcatid option:selected').val() + '", "filter": "' + $ck('#gmapfpplacefilter').val() + '"}';  
	var value = $ck('#filtre_gmapfpcatid option:selected').val();  
	var filter = $ck('#gmapfpplacefilter').val();  
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'update_places',
					'data'   : value,
					'filter' : filter,
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				if(response.data){
					var result = '';
					$ck("#gmapfpplaceid").empty();
					$ck.each(response.data[0], function (index, lieu) {
						$ck("#gmapfpplaceid").append($ck("<option></option>").attr("value", lieu['value']).text(lieu['text']));
					});
					var focus = $ck('.editfocus');
					FillGMapFPSelection(focus.attr('id'));
				} else {
					$ck('.status').html(response);
				}
				$ck('#sablier').fadeOut("fast");
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
};

function upload_gmapfpcatid() {    
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'get_place_cat',
					'data'   : '',
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				if(response.data){
					var result = '';
					$ck("#gmapfpcatid").empty();
					$ck.each(response.data[0], function (index, lieu) {
						$ck("#gmapfpcatid").append($ck("<option></option>").attr("value", lieu['value']).text(lieu['text']));
					});
					change_gmapfpcatid();
				} else {
					$ck('.status').html(response);
				}
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
};
</script>
<style type="text/css">

</style>