<?php
    /*
    * PDFFP Plugin for insert a PDF icon with this link in a article for Joomla! 3.x
    * Version J3_0
    * Creation date: Septembre 2013
    * Author: Fabrice4821 - www.gmapfp.org
    * Author email: webmaster@gmapfp.org
    * License GNU/GPL
    */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.filesystem.file' );

class PDFFPPluginModelGrid extends JModelLegacy
{
	var $path;

 	function getPDFs()
	{
		static $list;

		// Only process the list once per request
		if (is_array($list)) {
			return $list;
		}

		// Get current path from request
		$basePath 	= JPath::clean(COM_PDF_BASE);		
		$pdfs 	= array ();

		// Get the list of files and folders from the given folder
		jimport( 'joomla.filesystem.folder' );
		$fileList 	= JFolder::files($basePath);

		// Iterate over the files if they exist
		if ($fileList !== false) {
			foreach ($fileList as $file)
			{
				if (is_file($basePath.'/'.$file) && substr($file, 0, 1) != '.' && strtolower($file) !== 'index.html') {
					$tmp = new JObject();
					$tmp->name = $file;

					$ext = strtolower(JFile::getExt($file));
					if ($ext == 'pdf')
					{
						$tmp->path = JPath::clean($basePath.'/'.$file);
						$tmp->size = filesize($tmp->path);
						$tmp->size = $this->parseSize($tmp->size);
						$tmp->path = COM_PDF_JURI.'/'.$file;
						$pdfs[] = $tmp;
					}
				}
			}
		}

		return $pdfs;
	}
	
	function parseSize($size)
	{
		if ($size < 1024) {
			return $size . ' bytes';
		}
		else
		{
			if ($size >= 1024 && $size < 1024 * 1024) {
				return sprintf('%01.2f', $size / 1024.0) . ' Kb';
			} else {
				return sprintf('%01.2f', $size / (1024.0 * 1024)) . ' Mb';
			}
		}
	}

}